package com.bitbof.escape.entities;

import org.lwjgl.examples.spaceinvaders.Texture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

import com.bitbof.escape.Art;
import com.bitbof.escape.Sound;

public class Cutter implements Entity {
	
	public float counter = 0;
	public Vector2f pos;
	public World world;
	public Texture texture;
	public float width = 512, height = 512;
	public boolean pull = true;
	public boolean fadeout = false;
	public float alpha = 1;
	public float v = 0;
	public int wait = 0;
	
	public Cutter( World world, float x , float y) {
		this.world = world;
		pos = new Vector2f(x,y);
	}
	
	@Override
	public void tick() {
		
		if(fadeout) {
			alpha *= 0.9f;
			return;
		}
		if(wait > 0) {
			wait--;
			return;
		}
		if(pull) {
			counter += 0.005;
			v = 0;
		} else {
			v += 0.01f;
			counter -= v;
			
		}
		
		if(counter > 1) {
			counter = 1;
			pull = false;
		} else if(counter < 0) {
			counter = 0;
			pull = true;
			
			//playerstuff
			float dist = new Vector2f(pos.x - world.player.pos.x, pos.y - world.player.pos.y).length();
			if(dist < 249) {
				world.player.band = null;
				fadeout= true;
				Sound.end.play();
				world.pop.wait = 1000;
				world.pop.in = 500;
				world.pop.show = 10000;
				world.pop.counter = 0;
				world.pop.texture = Art.end;
			} else {
				if(dist < 4000) {
					dist = Math.max(1, dist/2000f);
					float gain = 1/dist*0.85f;
					Sound.cutter.setGain(gain);
					
				
					Sound.cutter.play();
				}
				wait = 20;
			}
			
			
		}
	}

	@Override
	public void render() {
		texture = Art.cutter;
		texture.bind();
		
		float degR = counter*90 - 95;
		float degL = -counter*90 + 95;
		
		{ // right blade
			GL11.glPushMatrix();
			GL11.glColor4f(1, 1, 1, alpha);
			GL11.glTranslatef(pos.x, pos.y, 0);
			GL11.glRotatef(degR, 0, 0, 1);
	
			GL11.glScalef(width, height, 0);
	
			GL11.glBegin(GL11.GL_QUADS);
			GL11.glTexCoord2f(0, 0);
			GL11.glVertex2f(-0.5f, -0.5f);
			GL11.glTexCoord2f(0, texture.getHeight());
			GL11.glVertex2f(0.5f, -0.5f);
			GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
			GL11.glVertex2f(0.5f, 0.5f);
			GL11.glTexCoord2f(texture.getWidth(), 0);
			GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();
	
			GL11.glPopMatrix();
		}
		{ // left blade
			GL11.glPushMatrix();
			GL11.glColor4f(1, 1, 1, alpha);
			GL11.glTranslatef(pos.x, pos.y, 0);
			GL11.glRotatef(degL, 0, 0, 1);
	
			GL11.glScalef(width, height, 0);
	
			GL11.glBegin(GL11.GL_QUADS);
			GL11.glTexCoord2f(0, 0);
			GL11.glVertex2f(0.5f, -0.5f);
			GL11.glTexCoord2f(0, texture.getHeight());
			GL11.glVertex2f(-0.5f, -0.5f);
			GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
			GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glTexCoord2f(texture.getWidth(), 0);
			GL11.glVertex2f(0.5f, 0.5f);
			GL11.glEnd();
	
			GL11.glPopMatrix();
		}
	}

	@Override
	public boolean isAlive() {
		return true;
	}
	

}
